﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderPlaceOfServiceMap
    {
        public static async Task<IQueryable<ProviderPlaceOfService>> MapProviderPlaceOfServiceCodes(List<ppms_providerplaceofservice> ppmsPlaceOfServices)
        {
            var placeOfServices = new List<ProviderPlaceOfService> { };
            foreach (var ppmsPlaceOfService in ppmsPlaceOfServices)
            {
                var placeOfService = new ProviderPlaceOfService();
                if (ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_placeofservicecode") != null)
                {
                    placeOfService.Code = (string)ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_placeofservicecode").Value;
                }
                if (ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_name") != null)
                {
                    placeOfService.Name = (string)ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_name").Value;
                }
                if (ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_placeofservicedescription") != null){
                    placeOfService.Description = (string)ppmsPlaceOfService.GetAttributeValue<AliasedValue>("placeofservicecode.ppms_placeofservicedescription").Value;
                }
                placeOfServices.Add(placeOfService);
            }
            return placeOfServices.AsQueryable();
        }
        
    }
}